#version 330
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// infinit cube waveMod01.fsh  by  ChGrenier   
//https://www.shadertoy.com/view/cly3Wd
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/* raymarching rendering based on jlfwong tutorial
 * https://www.shadertoy.com/user/jlfwong
 * https://jamie-wong.com/2016/07/15/ray-marching-signed-distance-functions/
 */
const int MAX_MARCHING_STEPS = 255;
const float MIN_DIST = 0.;
const float MAX_DIST = 100.;
const float EPSILON = 0.0005;
const float PRECISION = 0.001;

// start Common //
vec2 OpRepetition(vec2 pos, float interval)
{
    return pos - interval * round(pos/interval);
}


float sdRoundBox( vec3 p, vec3 b, float r )// https://iquilezles.org/articles/distfunctions/
{
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0) - r;
}



vec3 uhash3( uvec3 x ) // iq version
{
    uint k = 1103515245U;
    x = ((x>>8U)^x.yzx)*k;
    x = ((x>>8U)^x.yzx)*k;
    x = ((x>>8U)^x.yzx)*k;
    
    return vec3(x)/float(0xffffffffU);
}



vec3 hash( vec3 f ) //  FabriceNeyret2 version
{ 
    return uhash3( uvec3( floatBitsToUint(f.x),
                          floatBitsToUint(f.y),
                          floatBitsToUint(f.z) ) );
}
// end Common //



vec2 SDFscene(vec3 sampleCoords) 
{
    sampleCoords.xz -= vec2(2.4,2.1)*iTime;
    
    vec3 position = sampleCoords;
    float base = 0.24;
    float space = 0.08;
    
    float box_tot_size = base + space;
    
    vec2 box_id = floor((sampleCoords.xz+box_tot_size)/(2.*box_tot_size));
    float MatId = length(hash(vec3(box_id.x, space, box_id.y)));
    
    
    position.y += 0.12*sin(box_id.x - box_id.y + 1.2*iTime);
    position.y += 0.15*cos(box_id.x + box_id.y + 0.8*iTime);
    
    position.xz = OpRepetition(position.xz, 2.*box_tot_size);
    
    float radius = base * (0.5 * cos(0.8*iTime+3.14) + 0.5);
    
    float box = sdRoundBox(position, vec3(base-radius), radius);
    
    
    return vec2(box, MatId);
}





mat3 TexturesScene(float MatId)
{
    vec3 K_a = vec3(.1);
    vec3 K_d = normalize(hash(vec3(MatId, 0.24*MatId, 1.2*MatId)));
    float K_s = 1.;
    float shininess = 1.;
    
    
    return mat3(K_a, K_d, vec3(K_s, shininess, 0.));

}







vec2 shortestDistanceToSurface(vec3 eye, vec3 marchingDirection, float start, float end)
{
    float depth = start;
    vec2 surfaceInformation;
    vec3 marchingPos;
    
    for(int i = 0; i < MAX_MARCHING_STEPS; i++)
    {
        marchingPos = eye + depth * marchingDirection;
        surfaceInformation = SDFscene(marchingPos);
        
        depth += surfaceInformation.x;
        
        if(surfaceInformation.x < EPSILON || depth > end) break;
    }
    
    surfaceInformation.x = depth;
    
    return surfaceInformation;
}





vec3 rayDirection(float fieldOfView, vec2 size, vec2 fragCoord)
{
    vec2 xy = fragCoord - size / 2.;
    float z = size.y / tan(radians(fieldOfView)/2.);
    return normalize(vec3(xy,-z));
}




vec3 estimateNormal(vec3 sampleCoords)
{
    float dSDFdx = SDFscene(vec3(sampleCoords.x + EPSILON, sampleCoords.y, sampleCoords.z)).x - SDFscene(vec3(sampleCoords.x - EPSILON, sampleCoords.y, sampleCoords.z)).x;
    float dSDFdy = SDFscene(vec3(sampleCoords.x, sampleCoords.y + EPSILON, sampleCoords.z)).x - SDFscene(vec3(sampleCoords.x, sampleCoords.y - EPSILON, sampleCoords.z)).x;
    float dSDFdz = SDFscene(vec3(sampleCoords.x, sampleCoords.y, sampleCoords.z + EPSILON)).x - SDFscene(vec3(sampleCoords.x, sampleCoords.y, sampleCoords.z - EPSILON)).x;
    
    return normalize(vec3(dSDFdx, dSDFdy, dSDFdz));
}






// https://iquilezles.org/articles/rmshadows/
float softshadow(vec3 LightPos, vec3 ScenePos, float start, float end, float LightAngle) 
{
    float res = 1.0;
    float depth = start;

    vec3 N = estimateNormal(ScenePos);
    vec3 L = LightPos - ScenePos;

    vec3 LightDirection = normalize(L);


    for(int i = 0; i < MAX_MARCHING_STEPS ; i++) 
    {
      float surfaceInformation = SDFscene(ScenePos + LightDirection * depth).x;

      res = min(res, surfaceInformation/(LightAngle*depth));
      
      depth += clamp(surfaceInformation, PRECISION, 0.5);

      if(res < -1. || depth > end) break;
    }

    res = max(res,-1.0);
    return 0.25*(1.0+res)*(1.0+res)*(2.0-res);
}







vec3 LightContributionPhong(vec3 k_d, vec3 k_s, float alpha, vec3 LightPos, vec3 ScenePos, vec3 EyePos)
{
	vec3 N = estimateNormal(ScenePos);
	vec3 L = normalize(LightPos - ScenePos);
	vec3 V = normalize(EyePos - ScenePos);
	vec3 H = normalize(L + V);

    // shadows
    float shadows = softshadow(LightPos, ScenePos, 0.1, 3., 0.06);
    
    // lighting
    float dotLN = max(dot(N, L), 0.);
    float dotHN = max(dot(H, N), 0.);
    
	vec3 diffuse = k_d * dotLN;
	vec3 speculaire = k_s * pow(dotHN, alpha);

	return shadows*(diffuse + speculaire);
}




vec3 PhongIlluminationModel(vec3 k_a, vec3 k_d, vec3 k_s, float alpha, vec3 ScenePos, vec3 EyePos)
{
	// ambiant light
	vec3 ambiantLight = vec3(0.5);
	vec3 color = ambiantLight * k_a;

	// adding light
    vec3 LightPos = vec3(0.5, 4., 6.);;
	vec3 LightIntensity = vec3(0.5);
    
	color += LightIntensity * LightContributionPhong(k_d, k_s, alpha, LightPos, ScenePos, EyePos);
    
	return color;
}




mat4 LookAt(vec3 eye, vec3 center, vec3 up) {
    // Based on gluLookAt man page
    vec3 f = normalize(center - eye);
    vec3 s = normalize(cross(f, up));
    vec3 u = cross(s, f);
    return mat4(
        vec4(s, 0.0),
        vec4(u, 0.0),
        vec4(-f, 0.0),
        vec4(0.0, 0.0, 0.0, 1.)
    );
}





// ================================================
// =============== final rendering ================
// ================================================
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // ray direction it the view reference
    vec3 ViewDir = rayDirection(45., iResolution.xy, fragCoord); 
    
    // camera parameter
    vec3 eye = 3.*vec3(3., 2.4, 6.); 
    vec3 center = vec3(0.);
    vec3 up = vec3(0., 1., 0.);
    
    mat4 ViewToScene = LookAt(eye, center, up);
    
    // ray direction in the scene reference
    vec3 SceneDir = (ViewToScene * vec4(ViewDir, 1.)).xyz; 
    
    
    // distance and material id
    vec2 SceneInfo = shortestDistanceToSurface(eye, SceneDir, MIN_DIST, MAX_DIST);
    float dist = SceneInfo.x; 
    
    // no element found
   // if(dist > MAX_DIST - EPSILON) 
 //   {
  //      fragColor = vec4(0.);
  //      return 0;
 //   }
    
    // point on the scene
    vec3 pointPos = eye + dist * SceneDir;
    
    // textures
    mat3 MatInfo = TexturesScene(SceneInfo.y); // mat3(K_a, K_d, vec3(K_s, shininess, 0.))
    vec3 K_a = MatInfo[0];
    vec3 K_d = MatInfo[1];
    vec3 K_s = vec3(MatInfo[2].x);
    float shininess = MatInfo[2].y;
    
    // light
    vec3 color = PhongIlluminationModel(K_a, K_d, K_s, shininess, pointPos, eye);
    
    
    // final color
    fragColor = vec4(color, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
//vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc); // * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

